using UnityEngine;
using System.Collections.Generic;
using RimWorld;
using RimWorld.Planet;


namespace Verse.AI{
public class JobDriver_Goto : JobDriver
{
	protected override IEnumerable<Toil> MakeNewToils()
	{
		var gotoCell = Toils_Goto.GotoCell(TargetIndex.A, PathEndMode.OnCell);

		gotoCell.AddPreTickAction(() =>
			{
				// we check exit grid every tick to make sure the pawn leaves the map as soon as possible
				if( CurJob.exitMapOnArrival && pawn.Map.exitMapGrid.IsExitCell(pawn.Position) )
					TryExitMap();
			});

		// only allowed to join or create caravan?
		gotoCell.FailOn(() => CurJob.failIfCantJoinOrCreateCaravan && !CaravanExitMapUtility.CanExitMapAndJoinOrCreateCaravanNow(pawn));

		yield return gotoCell;

		Toil arrive = new Toil();
		arrive.initAction = () =>
			{
				// check if we arrived to our forced goto position
				if( pawn.mindState != null && pawn.mindState.forcedGotoPosition == TargetA.Cell )
					pawn.mindState.forcedGotoPosition = IntVec3.Invalid;

				if( CurJob.exitMapOnArrival && (pawn.Position.OnEdge(pawn.Map) || pawn.Map.exitMapGrid.IsExitCell(pawn.Position)) )
					TryExitMap();
			};

		arrive.defaultCompleteMode = ToilCompleteMode.Instant;
		yield return arrive;
	}

	private void TryExitMap()
	{
		// only allowed to join or create caravan?
		if( CurJob.failIfCantJoinOrCreateCaravan && !CaravanExitMapUtility.CanExitMapAndJoinOrCreateCaravanNow(pawn) )
			return;

		pawn.ExitMap(true);
	}
}}

